function [x,psi,rho]=psirho(sys,pas,xmin,xmax,TES,E)
% PSIRHO calcule les fonctions d'onde et
%   les densits de probabilit d'un objet physique 
%   interagissant avec une nergie potentielle.
%   [x,psi,rho]=psirho(sys,pas,xmin,xmax)
%       >> sys = Systme {objet physique-nergie potentielle}
%       >> pas = incrment selon l'axe x
%       >> xmin = limite infrieure du domaine graphique
%       >> xmax = limite suprieure du domaine graphique
%       << x = position sur l'axe x
%       << psi = fonction d'onde de l'objet physique
%       << rho = densit de probabilit de l'objet physique
%
%   Olivier Pujol : septembre 2013
%
%% Vrifications

if (pas>=0.01),error('Le pas est peut-tre trop grand !');end
if ( (xmin>sys{1}{1}(5))||(xmax<sys{1}{1}(6)) ),error('Le systme est hors du domaine !');end

%% Etats de diffusion ou tats confins

iconf=input('S''agit-il d''un tat confin ? oui (tapez 1) / non (tapez 0) ');

switch class(sys)
    case 'marche' 
        [x,rho]=psirho(sys,pas,xmin,xmax);
    case 'cell'
        
%% Choix de la valeur de l'nergie En de l'objet physique. On repre
%   l'indice iE correspondant  l'cart le plus petit entre En et E

if (length(E)>=2)
    En=input('Choisir une valeur de l''nergie pour l''objet physique : ');
    Ep=nan(1,length(sys{1}));
    Ep(1)=sys{1}{1}(1);
    for ic=2:length(sys{1})
        Ep(ic)=get(sys{1}{ic},'EnergiePotentielleSortie');
    end
% % % %     En=min(Ep)+En; % Si origine en haut du puits    
    iE=find(abs(abs(En-E)-min(abs(En-E)))<eps,1,'first');
end
if (length(E)==1),iE=1;end

%% Initialisation

x=cell(1,length(sys{iE}));      % Variable d'espace
psi=cell(1,length(sys{iE}));    % Fonction d'onde
rho=cell(1,length(sys{iE}));    % Densit linique de probabilit
    
%% Etats de diffusion

if (iconf==0)
        
        % Calcul dans la rgion d'entre
        x{1}=linspace(xmin,sys{iE}{1}(5),1+(sys{iE}{1}(5)-xmin)/pas);
        k=sys{iE}{1}(3);
        Amp=[1;-TES{iE}(2,1)/TES{iE}(2,2)];
        psi{1}=nan(size(x{1}));
        psi{1}=(1/sqrt(k))*( Amp(1)*exp(i*k*(x{1}-sys{iE}{1}(5))) ...
                            +Amp(2)*exp(-i*k*(x{1}-sys{iE}{1}(5))) );
        rho{1}=cell(size(x{1}));
        rho{1}=psi{1}.*conj(psi{1});
        
        % Calcul dans les rgions suivantes 
        for n=2:length(sys{iE})-1
            Amp=matrix(sys{iE}{n})*Amp;
            x1=get(sys{iE}{n},'Position');
            x2=get(sys{iE}{n+1},'Position');
            x{n}=linspace(x1,x2,1+(x2-x1)/pas);
            k=get(sys{iE}{n},'VecteurOndeSortie');
            psi{n}=nan(size(x{n}));
            psi{n}=(1/sqrt(k))*( Amp(1)*exp(i*k*(x{n}-x1)) ...
                                +Amp(2)*exp(-i*k*(x{n}-x1)) );
            rho{n}=nan(size(x{n}));
            rho{n}=psi{n}.*conj(psi{n});
            Amp=translation(sys{iE}{n},sys{iE}{n+1})*Amp;
        end

        % Calcul dans la rgion de sortie
        x{n+1}=linspace(sys{iE}{1}(6),xmax,(xmax-sys{iE}{1}(6))/pas);
        k=sys{iE}{1}(4);
        psi{n+1}=nan(size(x{n+1}));
        psi{n+1}=(1/sqrt(k))*( (1/TES{iE}(2,2))*exp(i*k*(x{n+1}-sys{iE}{1}(6))) );
        rho{n+1}=nan(size(x{n+1}));
        rho{n+1}=psi{n+1}.*conj(psi{n+1});
end

%% Etats confins

if (iconf==1)
        x{1}=linspace(xmin,sys{iE}{1}(5),1+(sys{iE}{1}(5)-xmin)/pas);
        k=sys{iE}{1}(3);
        Amp=[0;1];
        psi{1}=nan(size(x{1}));
        psi{1}=(1/sqrt(k))*( Amp(2)*exp(-i*k*(x{1}-sys{iE}{1}(5))) );
        rho{1}=nan(size(x{1}));
        rho{1}=psi{1}.*conj(psi{1});
        
        % Calcul dans les rgions suivantes 
        for n=2:length(sys{iE})-1
            Amp=matrix(sys{iE}{n})*Amp;
            x1=get(sys{iE}{n},'Position');
            x2=get(sys{iE}{n+1},'Position');
            x{n}=linspace(x1,x2,1+(x2-x1)/pas);
            k=get(sys{iE}{n},'VecteurOndeSortie');
            psi{n}=nan(size(x{n}));
            psi{n}=(1/sqrt(k))*( Amp(1)*exp(i*k*(x{n}-x1)) ...
                                +Amp(2)*exp(-i*k*(x{n}-x1)) );
            rho{n}=nan(size(x{n}));
            rho{n}=psi{n}.*conj(psi{n});
            Amp=translation(sys{iE}{n},sys{iE}{n+1})*Amp;
        end

        % Calcul dans la rgion de sortie
        x{n+1}=linspace(sys{iE}{1}(6),xmax,(xmax-sys{iE}{1}(6))/pas);
        k=sys{iE}{1}(4);
        Amp=matrix(sys{iE}{length(sys{iE})})*Amp;
        psi{n+1}=nan(size(x{n+1}));
        psi{n+1}=(1/sqrt(k))*( Amp(1)*exp(i*k*(x{n+1}-sys{iE}{1}(6))) );
        rho{n+1}=nan(size(x{n+1}));
        rho{n+1}=psi{n+1}.*conj(psi{n+1});    

end 

        otherwise
        error('Mauvais type d''argument !');

end

%% Normalisation de rho : on dtermine l'aire sous la courbe rho(x) entre xmin et xmax.

aire=0;
for iz=1:length(sys{iE})
aire = aire+sum((rho{iz}(1:end-1)+rho{iz}(2:end))*pas)/2;
end
for iz=1:length(sys{iE})
    rho{iz}=rho{iz}/aire;
    psi{iz}=psi{iz}/sqrt(aire);
end

clear Amp aire iz

return;